' SlashMaze -- a version of the classic Commodore Pet one-line Maze
' Version 1.0.0 7/20/2020 William M Leue

dim integer cellsize = 16
dim integer nhoriz = 800/cellsize
dim integer nvert = 600/cellsize

dim integer row, col
dim inteegr r, g, b

print "The Commodore PET personal computer supported a famous"
print "one-line BASIC program that filled the screen with a"
print "random maze created out of only two graphic characters:"
print "a forward slash and a backward slash. This worked"
print "because the graphic characters were square. The CMM2"
print "characters are not square and so the PET trick won't work."
print "Instead, this program uses short lines oriented at"
print "45 degrees left and right to get a similar effect."
print "Sadly, it takes more than one line of BASIC to make it work."
print ""
print "Press any key to continue..."
do : loop until INKEY$ <> ""
cls
xx$ = INKEY$
 
do
  cls
  r = rnd*127 + 126 : g = RND*127 + 126 : b = RND*127 + 126
  for row = 1 to nvert
    for col = 1 to nhoriz
      DrawCell(row, col)
    next col
  next row
  pause 3000
loop until INKEY$ <> ""
end

sub DrawCell(row, col)
  local integer x1, y1, x2, y2, slant
  local integer cx, cy. x3. y3. x4, y4, x5, y5, x6, y6
  cx = col*cellsize
  cy = row*cellsize
  if rnd() > 0.5 then
    slant = 1
  else 
    slant = -1
  end if
  if slant > 0 then
    x1 = cx : y1 = cy + cellsize
    x2 = cx + cellsize : y2 = cy
  else
    x1 = cx : y1 = cy
    x2 = cx + cellsize : y2 = cy + cellsize
  end if
  line x1, y1, x2, y2,,RGB(r, g, b)
end sub

